<?php
// FILE: protect_vulnerability_exceptions.php
// protecting against common vulnerabilities

// use "try" and "catch" to trap exceptions

$mysql_host 		= "localhost";
$mysql_database 	= "sweetscomplete";
$mysql_user 		= "sweetscomplete";
$mysql_password 	= "password";
$pdoErrException	= array(PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION);
$pdoErrSilent		= array(PDO::ATTR_ERRMODE => PDO::ERRMODE_SILENT);
$dsn 				= NULL;
$pdo 				= NULL;
$dsn = "mysql:host=$mysql_host;dbname=$mysql_database";

$silent = FALSE;
$output = '';

try {
	if ($silent) {
		// PDO error mode should be silent for production
		$pdo = new PDO($dsn, $mysql_user, $mysql_password, $pdoErrSilent);
	} else {
		// PDO error mode should be exception or warning for development
		// however, you can turn display_errors off and log the errors if needed
		$pdo = new PDO($dsn, $mysql_user, $mysql_password, $pdoErrException);
	}
	$stmt = $pdo->query('This Is Not SQL');
	while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
		$output .= implode(':', $row) . PHP_EOL;
	}
} catch (PDOException $e) {
	$output .= 'Database Error';
	error_log($e->getMessage(), 0);
} catch (Exception $e) {
	$output .= 'Database Error';
	error_log($e->getMessage(), 0);
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Protect Against Vulnerabilities</title>
</head>
<body>
<h1>protect_vulnerability_exceptions.php</h1>

<?php echo $output; ?>

<br />To Do:
<br />Have a look at the PHP error log.

</body>
</html>
